#include <iostream>
#include <vector>
#include <unordered_map>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (long long& x : a) cin >> x;

    vector<long long> prefix(n + 1, 0);
    unordered_map<long long, int> first;
    unordered_map<long long, int> last;

    for (int i = 0; i < n; ++i)
        prefix[i + 1] = prefix[i] + a[i];

    for (int i = 0; i <= n; ++i) {
        if (!first.count(prefix[i])) first[prefix[i]] = i;
        last[prefix[i]] = i;
    }

    int answer = 0;

    for (const auto& [sum, l] : first) {
        int r = last[sum];
        if (r - l <= 0) continue;

        unordered_map<long long, int> freq;
        int maxFreq = 0;
        for (int k = l; k < r; ++k) {
            freq[a[k]]++;
            maxFreq = max(maxFreq, freq[a[k]]);
        }

        answer = max(answer, maxFreq);
    }

    cout << answer << '\n';
    return 0;
}